///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void performTransfer(IClientVirtualDevice *, int, char *);
HANDLE execSQL(int);
int checkSQL(void);
int ProcessSQLDatabase(char *);
void SQLProcessExit(void);
void SQLProcessShutdown(void);

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// ------SQL Backup Globals
IClientVirtualDeviceSet2 *vds = NULL;
IClientVirtualDevice *vd      = NULL;
HANDLE hThread                = NULL;
VDConfig config;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ResetSQLProcess(void)
{
    ClearMem(SQLProcess.DataBase, 256);
    ClearMem(SQLProcess.Driver, 256);
    ClearMem(SQLProcess.Server, 256);
    ClearMem(SQLProcess.UserID, 256);
    ClearMem(SQLProcess.UserPW, 256);

    SQLProcess.IsTrusted = FALSE;
    SQLProcess.Backup    = FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL BackupJob(char *FileName)
{
    DWORD Flags = 0;
    if(CurrentlyRunning == TRUE)
    {
//        MessageBox(MainDialog_hWnd, "BackupJob Running.", TitleCaption, 0 );
        return FALSE;
    }

    CurrentlyRunning = TRUE;

    SQLProcess.Backup = TRUE;
    SQLProcessThread_Handle = CreateThread(NULL, 0, SQLProcessThread, (LPVOID)FileName, Flags, &SQLProcessThread_ID);

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL RestoreJob(char *FileName)
{
    DWORD Flags = 0;
    if(CurrentlyRunning == TRUE)
    {
//        MessageBox(MainDialog_hWnd, "RestoreJob Running.", TitleCaption, 0 );
        return FALSE;
    }

    CurrentlyRunning = TRUE;

    SQLProcess.Backup = FALSE;
    SQLProcessThread_Handle = CreateThread(NULL, 0, SQLProcessThread, (LPVOID)FileName, Flags, &SQLProcessThread_ID);

    return TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CancelSQLOperation(void)
{
    char TextMessage[10240];

    SQLProcessShutdown();

	SuspendThread(SQLProcessThread_Handle);

    TerminateThread(SQLProcessThread_Handle, 0);
    CloseHandle(SQLProcessThread_Handle);

    sprintf(TextMessage, "Execution complete. (Canceled)");
    AddToJobHistory(TextMessage);

    AddToJobHistory(Seperator);

    ResetSQLProcess();

    CurrentlyRunning  = FALSE;
    DoingTransfer     = FALSE;
    CancelFlag        = FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI SQLProcessThread(LPVOID xData)
{
    char TextMessage[10240];

    char *SQLFile = (char *) xData;

    CancelFlag = FALSE;

    SYSTEMTIME ST;

    char Date[64];
    char Time[64];

	GetLocalTime(&ST);
    GetDateFormat(NULL, NULL, &ST, "MM-dd-yyyy", Date, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, Time, 64);

    if(RunningManual == FALSE)
    {
        int Sched = SQLProcess.ScheduleItem;

        sprintf(TextMessage, "Starting scheduled backup #:%d / ID:%d (%s - %s)", Sched, BT[Sched].ScheduleID, Date, Time);
        AddToJobHistory(TextMessage);

        sprintf(TextMessage, "\t%s (%s)", BT[Sched].Name, BT[Sched].Description);
        AddToJobHistory(TextMessage);

        sprintf(TextMessage, "\t%s:%s:%s -> %s", BT[Sched].SQLServer, BT[Sched].DBDriver, BT[Sched].Database, BT[Sched].Filename);
        AddToJobHistory(TextMessage);
    }

    if(RunningManual == TRUE)
    {
        if(SQLProcess.Backup == TRUE)
            sprintf(TextMessage, "Starting manual backup. (%s - %s)", Date, Time);

        if(SQLProcess.Backup == FALSE)
            sprintf(TextMessage, "Starting manual restore. (%s - %s)", Date, Time);

        AddToJobHistory(TextMessage);

        if(SQLProcess.Backup == TRUE)
            sprintf(TextMessage, "\t%s:%s:%s -> %s", SQLProcess.Server, SQLProcess.Driver, SQLProcess.DataBase, SQLFile);

        if(SQLProcess.Backup == FALSE)
            sprintf(TextMessage, "\t%s -> %s:%s:%s", SQLFile, SQLProcess.Server, SQLProcess.Driver, SQLProcess.DataBase);

        AddToJobHistory(TextMessage);
    }

    sprintf(TextMessage, "\tPlease wait... Initializing.");
    AddToJobHistory(TextMessage);

    //----------------------------------------------------
    ProcessSQLDatabase(SQLFile); // Actually do the work -
    //----------------------------------------------------

	GetLocalTime(&ST);
    GetDateFormat(NULL, NULL, &ST, "MM-dd-yyyy", Date, 64);
    GetTimeFormat(LOCALE_USER_DEFAULT, 0, &ST, NULL, Time, 64);

    sprintf(TextMessage, "Execution complete. (%s - %s)", Date, Time);
    AddToJobHistory(TextMessage);

    AddToJobHistory(Seperator);

    ResetSQLProcess();

    RunningManual     = FALSE;
    CurrentlyRunning  = FALSE;
    DoingTransfer     = FALSE;
    CancelFlag        = FALSE;
	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SQLProcessExit(void)
{
    CoUninitialize () ;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SQLProcessShutdown(void)
{
    char TextMessage[10240];

    // Close the set
    vds->Close ();

    if(CancelFlag == FALSE)
    {
        // Obtain the SQL completion information
    	if (hThread != NULL)
    	{
    	    if (checkSQL())
    			sprintf(TextMessage, "\tThe SQL command executed successfully.");
    		else sprintf(TextMessage, "\tThe SQL command failed.");

            AddToJobHistory(TextMessage);

        	CloseHandle (hThread);
    	}
    }

    // COM reference counting: Release the interface.
    vds->Release () ;

    SQLProcessExit();

    if(CancelFlag == TRUE)
    {
        sprintf(TextMessage, "\tOperation canceled.");
        AddToJobHistory(TextMessage);
    }

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ProcessSQLDatabase(char *FileName)
{
    char TextMessage[10240];

    HRESULT hResult               = NULL;
    BOOL doBackup                 = SQLProcess.Backup;

    sprintf(TextMessage, "\tPerforming SQL virtual device %s.", (doBackup) ? "backup" : "restore");
    AddToJobHistory(TextMessage);

    // Initialize COM Library
    // Note: _WIN32_DCOM must be defined during the compile.
    //
    hResult = CoInitializeEx (NULL, COINIT_MULTITHREADED);

    if( !SUCCEEDED(hResult) )
    {
        sprintf(TextMessage, "\tFailed to CoInitialize: (x%X)", hResult);
    	AddToJobHistory(TextMessage);
    }

    // Get an interface to the device set.
    // Notice how we use a single IID for both the class and interface identifiers.
    hResult = CoCreateInstance(CLSID_MSSQL_ClientVirtualDeviceSet, NULL, CLSCTX_INPROC_SERVER, IID_IClientVirtualDeviceSet2, (void**)&vds);

    if (!SUCCEEDED (hResult))
    {
        // This failure might happen if the DLL was not registered,
    	// or if the application is using the wrong interface id (IID).
        //
        sprintf(TextMessage, "\tCould not create VD component: (x%X)", hResult);
    	AddToJobHistory(TextMessage);

//      sprintf(TextMessage, "\tCheck registration of SQLVDI.DLL and value of IID");
//    	AddToJobHistory(TextMessage);
        SQLProcessExit();
        return 0;
    }

    // Setup the VDI configuration we want to use.
    // This program doesn't use any fancy features, so the
    // only field to setup is the deviceCount.
    //
    // The server will treat the virtual device just like a pipe:
    // I/O will be strictly sequential with only the basic commands.
    //
    memset (&config, 0, sizeof(config));
    config.deviceCount = 1;

    // Create the virtual device set
    hResult = vds->CreateEx(NULL, L"SUPERBAK", &config);
    if (!SUCCEEDED (hResult))
    {
        sprintf(TextMessage, "\tVDS::Create failed: (x%X)", hResult);
    	AddToJobHistory(TextMessage);
        SQLProcessExit();
        return 0;
    }

    // Send the SQL command, by starting a thread to handle the ODBC
	sprintf(TextMessage, "\tSending SQL strings...");
    AddToJobHistory(TextMessage);

	hThread = execSQL (doBackup);
	if (hThread == NULL)
    {
        sprintf(TextMessage, "\tSQL execution failed.");
    	AddToJobHistory(TextMessage);
        SQLProcessShutdown();
        return 0;
    }

    // Wait for the server to connect, completing the configuration.
    //
    sprintf(TextMessage, "\tWaiting for SQLServer to respond...");
    AddToJobHistory(TextMessage);

    while (!SUCCEEDED (hResult=vds->GetConfiguration (1000, &config)))
    {
        if (hResult == VD_E_TIMEOUT)
        {
			// Check on the SQL thread
			//
			DWORD	rc = WaitForSingleObject (hThread, 1000);
			if (rc == WAIT_OBJECT_0)
			{
				sprintf(TextMessage, "\tSQL command failed before VD transfer.");
            	AddToJobHistory(TextMessage);
                SQLProcessShutdown();
                return 0;
			}
			if (rc == WAIT_TIMEOUT)
			{
				continue;
			}
			sprintf(TextMessage, "\tCheck on SQL failed: (%d)", rc);
        	AddToJobHistory(TextMessage);
            SQLProcessShutdown();
            return 0;
		}

        sprintf(TextMessage, "\tVDS::Getconfig failed: *x%X(", hResult);
    	AddToJobHistory(TextMessage);
        SQLProcessShutdown();
        return 0;
    }

    // Open the single device in the set.
    //
    hResult = vds->OpenDevice (L"SUPERBAK", &vd);
    if (!SUCCEEDED(hResult))
    {
        sprintf(TextMessage, "\tVDS::OpenDevice failed: (x%X)", hResult);
    	AddToJobHistory(TextMessage);
        SQLProcessShutdown();
        return 0;
    }

    sprintf(TextMessage, "\tPerforming data transfer...");
    AddToJobHistory(TextMessage);

    performTransfer(vd, doBackup, FileName);

    SQLProcessShutdown();

    return 0 ;
}

///////////////////////////////////////////////////////////////////////////////////////////
//---------------------------------------------------------------------------
// ODBC Message processing routine.
// This is SQLServer specific, to show native message IDs, sev, state.
//
// The routine will watch for message 3014 in order to detect
// a successful backup/restore operation.  This is useful for
// operations like RESTORE which can sometimes recover from
// errors (error messages will be followed by the 3014 success message).
//	SQLSMALLINT		handle_type,    // ODBC handle type
//    SQLHANDLE		handle,         // ODBC handle
//    int				ConnInd,        // TRUE if sucessful connection made
//    int*            pBackupSuccess) // Set TRUE if a 3014 message is seen.
void ProcessMessages(SQLSMALLINT handle_type, SQLHANDLE handle, int ConnInd, int *pBackupSuccess)
{
    RETCODE			plm_retcode = SQL_SUCCESS;
    UCHAR           plm_szSqlState[SQL_SQLSTATE_SIZE + 1];
	UCHAR		    plm_szErrorMsg[SQL_MAX_MESSAGE_LENGTH + 1];
    SDWORD          plm_pfNativeError = 0L;
    SWORD           plm_pcbErrorMsg = 0;
    SQLSMALLINT     plm_cRecNmbr = 1;
    SDWORD          plm_SS_MsgState = 0, plm_SS_Severity = 0;
    SQLINTEGER      plm_Rownumber = 0;
    USHORT          plm_SS_Line;
    SQLSMALLINT     plm_cbSS_Procname, plm_cbSS_Srvname;
    SQLCHAR         plm_SS_Procname[MAXNAME], plm_SS_Srvname[MAXNAME];

    while (plm_retcode != SQL_NO_DATA_FOUND) 
	{
        plm_retcode = SQLGetDiagRec(handle_type, handle,
            plm_cRecNmbr, plm_szSqlState, &plm_pfNativeError,
            plm_szErrorMsg, SQL_MAX_MESSAGE_LENGTH, &plm_pcbErrorMsg);

        // Note that if the application has not yet made a
        // successful connection, the SQLGetDiagField
        // information has not yet been cached by ODBC
        // Driver Manager and these calls to SQLGetDiagField
        // will fail.
        //
        if (plm_retcode != SQL_NO_DATA_FOUND) 
		{
            if (ConnInd) 
			{
                plm_retcode = SQLGetDiagField(
                    handle_type, handle, plm_cRecNmbr,
                    SQL_DIAG_ROW_NUMBER, &plm_Rownumber,
                    SQL_IS_INTEGER,
                    NULL);

                plm_retcode = SQLGetDiagField(
                    handle_type, handle, plm_cRecNmbr,
                    SQL_DIAG_SS_LINE, &plm_SS_Line,
                    SQL_IS_INTEGER,
                    NULL);

                plm_retcode = SQLGetDiagField(
                    handle_type, handle, plm_cRecNmbr,
                    SQL_DIAG_SS_MSGSTATE, &plm_SS_MsgState,
                    SQL_IS_INTEGER,
                    NULL);

                plm_retcode = SQLGetDiagField(
                    handle_type, handle, plm_cRecNmbr,
                    SQL_DIAG_SS_SEVERITY, &plm_SS_Severity,
                    SQL_IS_INTEGER,
                    NULL);

                plm_retcode = SQLGetDiagField(
                    handle_type, handle, plm_cRecNmbr,
                    SQL_DIAG_SS_PROCNAME, &plm_SS_Procname,
                    sizeof(plm_SS_Procname),
                    &plm_cbSS_Procname);

                plm_retcode = SQLGetDiagField(
                    handle_type, handle, plm_cRecNmbr,
                    SQL_DIAG_SS_SRVNAME, &plm_SS_Srvname,
                    sizeof(plm_SS_Srvname),
                    &plm_cbSS_Srvname);

                /*
                sprintf(TextMessage, "Msg %d, SevLevel %d, State %d, SQLState %s",
                    plm_pfNativeError,
                    plm_SS_Severity,
                    plm_SS_MsgState,
                    plm_szSqlState);
                WriteToLog(TextMessage);
            	AddToJobHistory(TextMessage);
                */
            }

//          Long detailed description of whats going on
//          WriteToLog((char *)plm_szErrorMsg);
//          AddToJobHistory(TextMessage);

            if (pBackupSuccess && plm_pfNativeError == 3014)
            {
                *pBackupSuccess = TRUE;
            }
        }

        plm_cRecNmbr++; //Increment to next diagnostic record.
    } // End while.
}

///////////////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------------
// The mainline of the ODBC thread.
//
// Returns TRUE if a successful backup/restore is performed.
//
unsigned __stdcall SQLRoutine (void *parms)
{
    char TextMessage[10240];

	int	doBackup        = (int) parms;
	int	successDetected = FALSE;

	// ODBC handles
	//
	SQLHENV henv   = NULL;
	SQLHDBC hdbc   = NULL;
	SQLHSTMT hstmt = NULL;

    char Command[1024];
    char Connection[1024];

    if(doBackup)
    {
        char *Name        = NULL;
        char *Description = NULL;

        if(RunningManual == FALSE)
        {
            Name        = BT[ SQLProcess.ScheduleItem ].Name;
            Description = BT[ SQLProcess.ScheduleItem ].Description;
        }

        if(RunningManual == TRUE)
        {
            Name        = "Manual backup";
            Description = "Manual backup process.";
        }

        sprintf(Command, "BACKUP DATABASE %s TO VIRTUAL_DEVICE='SUPERBAK' WITH Name = '%s',Description='%s', MediaName='Disk media', MediaDescription='SUPERBAK disk media'", SQLProcess.DataBase, Name, Description);
    }
    else{
        sprintf(Command, "RESTORE DATABASE %s FROM VIRTUAL_DEVICE='SUPERBAK' %s", SQLProcess.DataBase, SQLProcess.RestoreStatement);
//      ErrorMessage(NULL, Command);
//      sprintf(Command, "RESTORE DATABASE %s FROM VIRTUAL_DEVICE='SUPERBAK'", SQLProcess.DataBase);
    }

    char *Trusted = NULL;

    if(SQLProcess.IsTrusted == TRUE)
        Trusted = "Yes";

    if(SQLProcess.IsTrusted == FALSE)
        Trusted = "No";

    sprintf(Connection, "DRIVER=%s;Trusted_Connection=%s;SERVER=%s;UID=%s;PWD=%s;", SQLProcess.Driver, Trusted, SQLProcess.Server, SQLProcess.UserID, SQLProcess.UserPW);

    int         sentSQL = FALSE;
    int         rc;

    #define     MAX_CONN_OUT 1024
    SQLCHAR     szOutConn[MAX_CONN_OUT];
    SQLSMALLINT cbOutConn;

    // Initialize the ODBC environment.
    //
    if (SQLAllocHandle (SQL_HANDLE_ENV, NULL, &henv) == SQL_ERROR)
        goto exit;

    // This is an ODBC v3 application
    //
    SQLSetEnvAttr (henv, SQL_ATTR_ODBC_VERSION, (void*) SQL_OV_ODBC3, SQL_IS_INTEGER);

    // Allocate a connection handle
    //
    if (SQLAllocHandle (SQL_HANDLE_DBC, henv, &hdbc) == SQL_ERROR)
    {
        sprintf(TextMessage, "\tHandle allocation failed on DBC.");
    	AddToJobHistory(TextMessage);
        goto exit;
    }

    // Connect to the server using Trusted connection.
    // Trusted connection uses integrated NT security.
	  // If you want to use mixed-mode Authentication, please set Trusted_Connection to no.
    rc = SQLDriverConnect(
        hdbc,
        NULL,   // no diaglogs please
        (SQLCHAR*) Connection,
        SQL_NTS,
        szOutConn,
        MAX_CONN_OUT, 
        &cbOutConn, 
        SQL_DRIVER_NOPROMPT);

    if(rc == SQL_ERROR)
    {
        SQLCHAR     szSqlState[20];
        SQLINTEGER  ssErr;
        SQLCHAR     szErrorMsg [MAX_CONN_OUT];
        SQLSMALLINT cbErrorMsg;

        sprintf(TextMessage, "\tFailed to connect to SQL server:");
    	AddToJobHistory(TextMessage);

        rc = SQLError(henv, hdbc, SQL_NULL_HSTMT, szSqlState, &ssErr, szErrorMsg, MAX_CONN_OUT, &cbErrorMsg);

        sprintf(TextMessage, "%s", szErrorMsg);
    	AddToJobHistory(TextMessage);

        goto exit;
    }

    // Get a statement handle
    //
    if (SQLAllocHandle(SQL_HANDLE_STMT, hdbc, &hstmt) == SQL_ERROR)
    {
        sprintf(TextMessage, "\tFailed to get statement handle");
        AddToJobHistory(TextMessage);

        ProcessMessages (SQL_HANDLE_DBC, hdbc, TRUE, NULL);
        goto exit;
    }

    // Execute the SQL
    rc = SQLExecDirect (hstmt, (SQLCHAR*)Command, SQL_NTS);

	// Extract all the resulting messages
	//

	SQLSMALLINT numResultCols;
	while (1)
	{
		switch (rc)
		{
			case SQL_ERROR:
				successDetected = FALSE;
				sprintf(TextMessage, "\tDirect SQL execution error encountered.");
            	AddToJobHistory(TextMessage);
				ProcessMessages (SQL_HANDLE_STMT, hstmt, TRUE, NULL);
				goto exit;
				break;

			case SQL_SUCCESS_WITH_INFO:
				ProcessMessages (SQL_HANDLE_STMT, hstmt, TRUE, NULL);
				// fall through

			case SQL_SUCCESS:
				successDetected = TRUE;

				numResultCols = 0;
				SQLNumResultCols (hstmt, &numResultCols);
				if (numResultCols > 0)
				{
					sprintf(TextMessage, "\tA result set with %d columns was produced.", (int)numResultCols);
                	AddToJobHistory(TextMessage);
				}
				break;

			case SQL_NO_DATA:
				// All results have been processed.  We are done.
				//
				goto exit;

			case SQL_NEED_DATA:
			case SQL_INVALID_HANDLE:
			case SQL_STILL_EXECUTING:
			default:
				successDetected = FALSE;
				sprintf(TextMessage, "\tUnexpected SQLExec result (%d)", rc);
            	AddToJobHistory(TextMessage);
				goto exit;
		}
		rc = SQLMoreResults (hstmt);
	}

exit:
	// Release the ODBC resources.
	//
    if (hstmt != NULL)
    {
        SQLFreeHandle(SQL_HANDLE_STMT, hstmt);
        hstmt = NULL;
    }

    if (hdbc != NULL)
    {
        SQLDisconnect(hdbc);
        SQLFreeHandle(SQL_HANDLE_DBC, hdbc);
        hdbc = NULL;
    }

    if (henv != NULL)
    {
        SQLFreeHandle(SQL_HANDLE_ENV, henv);
        henv = NULL;
    }

    return successDetected;
}


///////////////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------
//
// execSQL: Send the SQL to the server via ODBC.
//
// Return the thread handle (NULL on error).
//
HANDLE execSQL (int doBackup)
{
    char TextMessage[10240];

	unsigned int	threadId;
	HANDLE			hThread;

	hThread = (HANDLE)_beginthreadex(NULL, 0, SQLRoutine, (void*)doBackup, 0, &threadId);
	if (hThread == NULL)
	{
		sprintf(TextMessage, "\tFailed to create thread. (%d)", errno);
    	AddToJobHistory(TextMessage);
	}
	return hThread;
}

///////////////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------------------
//
// checkSQL: Wait for the T-SQL to complete, 
//	returns TRUE if statement successfully executed.
//
int checkSQL(void)
{
    char TextMessage[10240];

	if (hThread == NULL)
		return FALSE;

	DWORD rc = WaitForSingleObject(hThread, INFINITE);
	if(rc != WAIT_OBJECT_0)
	{
		sprintf(TextMessage, "\tFailed waiting on thread object: (%d)", rc);
    	AddToJobHistory(TextMessage);
		return FALSE;
	}
	if (!GetExitCodeThread (hThread, &rc))
	{
		sprintf(TextMessage, "\tFailed to get exit code: (%d)", GetLastError ());
    	AddToJobHistory(TextMessage);
		return FALSE;
	}
	return rc == TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////

//----------------------------------------------------------------------------------
// VDI data transfer handler.
//
// This routine reads commands from the server until a 'Close' status is received.
// It simply reads or writes a file 'SUPERBAK.dmp' in the current directory.
//
void performTransfer(IClientVirtualDevice *vd, int backup, char *FileName)
{
    char TextMessage[10240];

    FILE *          fh;
    VDC_Command     *cmd;
    DWORD           completionCode;
    DWORD           bytesTransferred;
    HRESULT         hr;

    float KBytesTransfered = 0;

    fh = fopen (FileName, (backup)? "wb" : "rb");
    if (fh == NULL )
    {
        sprintf(TextMessage, "\tFailed to open: %s", FileName);
    	AddToJobHistory(TextMessage);
        return;
    }

    DoingTransfer = TRUE;
    while( SUCCEEDED( hr = vd->GetCommand(INFINITE, &cmd) ) )
	{
        bytesTransferred = 0;

        switch (cmd->commandCode)
        {
            //----------------------------------------------------------------------
            case VDC_Read:
                bytesTransferred = fread (cmd->buffer, 1, cmd->size, fh);
                if (bytesTransferred == cmd->size)
                    completionCode = ERROR_SUCCESS;
                else
                    // assume failure is eof
                    completionCode = ERROR_HANDLE_EOF;
                break;

            //----------------------------------------------------------------------
            case VDC_Write:
                bytesTransferred = fwrite (cmd->buffer, 1, cmd->size, fh);
                if (bytesTransferred == cmd->size )
                {
                    completionCode = ERROR_SUCCESS;
                }
                else completionCode = ERROR_DISK_FULL; // assume failure is disk full
                break;

            //----------------------------------------------------------------------
            case VDC_Flush:
                fflush (fh);
                completionCode = ERROR_SUCCESS;
                break;

            //----------------------------------------------------------------------
            case VDC_ClearError:
                completionCode = ERROR_SUCCESS;
                break;

            //----------------------------------------------------------------------
            default:
                // If command is unknown...
                completionCode = ERROR_NOT_SUPPORTED;
        }

        if(CancelFlag == TRUE) break;

        hr = vd->CompleteCommand(cmd, completionCode, bytesTransferred, 0);
        if (!SUCCEEDED (hr))
        {
            sprintf(TextMessage, "\tVD failed on completion: (x%X)", hr);
        	AddToJobHistory(TextMessage);
            break;
        }

        KBytesTransfered = (KBytesTransfered + bytesTransferred);
/*
        if(WriteListBox == TRUE)
        {
            sprintf(TextMessage, "%.1f", KBytesTransfered / 1024);
        }
*/
    }


    sprintf(TextMessage, "\tTransfered %.1f KB.", KBytesTransfered / 1024);
    AddToJobHistory(TextMessage);

    DoingTransfer = FALSE;

    if(CancelFlag == FALSE)
    {
        if(hr != VD_E_CLOSE)
        {
            sprintf(TextMessage, "\tUnexpected VD termination: (x%X)", hr);
        	AddToJobHistory(TextMessage);
        }
        else
        {
            // As far as the data transfer is concerned, no
            // errors occurred.  The code which issues the SQL
            // must determine if the backup/restore was
            // really successful.
            sprintf(TextMessage, "\tSuccessfully completed data transfer.");
        	AddToJobHistory(TextMessage);
        }
    }

    fclose (fh);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

